VERSION 5.00
Begin VB.Form frmPIDCoeff 
   Caption         =   "Temperature PID Coefficients"
   ClientHeight    =   3945
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5715
   LinkTopic       =   "Form1"
   ScaleHeight     =   3945
   ScaleWidth      =   5715
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdCancelPID 
      Caption         =   "Cancel"
      Height          =   615
      Left            =   3720
      TabIndex        =   1
      Top             =   3000
      Width           =   1215
   End
   Begin VB.CommandButton cmdSaveSetup 
      Caption         =   "Save PIDs (Save Setup)"
      Height          =   615
      Left            =   2160
      TabIndex        =   18
      Top             =   3000
      Width           =   1215
   End
   Begin VB.CommandButton cmdOKPID 
      Caption         =   "OK"
      Height          =   615
      Left            =   600
      TabIndex        =   4
      Top             =   3000
      Width           =   1215
   End
   Begin VB.Frame fraPID 
      Caption         =   "PID Coefficients"
      Height          =   2175
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   5055
      Begin VB.OptionButton optPID 
         Caption         =   "Min Settle"
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   2
         Top             =   1080
         Width           =   1215
      End
      Begin VB.TextBox txtMSETKd 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   3480
         Locked          =   -1  'True
         TabIndex        =   14
         TabStop         =   0   'False
         Top             =   1080
         Width           =   852
      End
      Begin VB.TextBox txtMSETKi 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   2520
         Locked          =   -1  'True
         TabIndex        =   13
         TabStop         =   0   'False
         Top             =   1080
         Width           =   852
      End
      Begin VB.TextBox txtMSETKp 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   12
         TabStop         =   0   'False
         Top             =   1080
         Width           =   852
      End
      Begin VB.TextBox txtMOVKp 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   11
         TabStop         =   0   'False
         Top             =   1560
         Width           =   852
      End
      Begin VB.TextBox txtMOVKi 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   2520
         Locked          =   -1  'True
         TabIndex        =   10
         TabStop         =   0   'False
         Top             =   1560
         Width           =   852
      End
      Begin VB.TextBox txtMOVKd 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   3480
         Locked          =   -1  'True
         TabIndex        =   9
         TabStop         =   0   'False
         Top             =   1560
         Width           =   852
      End
      Begin VB.OptionButton optPID 
         Caption         =   "Min Overshoot"
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   3
         Top             =   1560
         Width           =   1335
      End
      Begin VB.OptionButton optPID 
         Caption         =   "Custom"
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   8
         Top             =   600
         Width           =   1215
      End
      Begin VB.TextBox txtCustomKp 
         Height          =   285
         Left            =   1560
         TabIndex        =   5
         Top             =   600
         Width           =   855
      End
      Begin VB.TextBox txtCustomKi 
         Height          =   285
         Left            =   2520
         TabIndex        =   6
         Top             =   600
         Width           =   855
      End
      Begin VB.TextBox txtCustomKd 
         Height          =   285
         Left            =   3480
         TabIndex        =   7
         Top             =   600
         Width           =   855
      End
      Begin VB.Label lblP 
         Caption         =   "Kp"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1800
         TabIndex        =   17
         Top             =   240
         Width           =   255
      End
      Begin VB.Label lblI 
         Caption         =   "Ki"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2760
         TabIndex        =   16
         Top             =   240
         Width           =   255
      End
      Begin VB.Label lblD 
         Caption         =   "Kd"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   3720
         TabIndex        =   15
         Top             =   240
         Width           =   255
      End
   End
End
Attribute VB_Name = "frmPIDCoeff"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'frmPIDCoeff displays PID coefficients and permits selection of
'the active PID set

Private Sub cmdCancelPID_Click()
'Close form, don't modify active PID values

frmPIDCoeff.Hide

End Sub

Private Sub cmdOKPID_Click()
'Send chosen set of PID to instrument, to be used for temp control
'Then hide this form

'If custom PID is chosen, ensure that each value is within limits which
'should have be checked with the _Validate function, but the last coeff
'entered may not have been validated
If optPID(3).value Then
    Call CheckCustomPID
End If


'Send chosen PIDs to 2510
Call SendKI(intKI2510, "sour:temp:lcon:gain " & sngOperKp)      'Send temperature control gain (P) coeff
Call SendKI(intKI2510, "sour:temp:lcon:int " & sngOperKi)       'Send integral
Call SendKI(intKI2510, "sour:temp:lcon:der " & sngOperKd)       'Send derivative

'Recall PIDs and display
Call GetPresentPID

frmPIDCoeff.Hide

End Sub

Private Sub cmdSaveSetup_Click()
'This procedure saves the chosen PIDs by using the savesetup
'feature (using memory location 0 of 0-4).  It also changes
'the power-on setup to use mem loc 0.
Dim choice As Integer

''Retrieve PIDs presently stored in 2510
'If SendKI(intKI2510, "sour:temp:lcon:gain?") Then Exit Sub
'strpresKp = QueryKI(intKI2510)
'
''get present Ki
'If SendKI(intKI2510, "sour:temp:lcon:int?") Then Exit Sub
'strpresKi = QueryKI(intKI2510)
'
''get present Kd
'If SendKI(intKI2510, "sour:temp:lcon:der?") Then Exit Sub
'strpresKd = QueryKI(intKI2510)

choice = MsgBox("These PID coefficients will be saved in the instrument: " & vbCrLf & vbCrLf & _
        "Kp = " & sngOperKp & vbCrLf & _
        "Ki =  " & sngOperKi & vbCrLf & _
        "Kd = " & sngOperKd & vbCrLf & vbCrLf & _
        "using memory location 0 and the instrument will power-up" & vbCrLf & _
        "with these settings.", vbOKCancel, "Save PID Coefficients")                 'Msgbox with OK and Cancel buttons
If choice = 1 Then              'OK chosen
    If SendKI(intKI2510, "sour:temp:lcon:gain " & sngOperKp) Then Exit Sub  'Save coeff in instrument
    If SendKI(intKI2510, "sour:temp:lcon:int " & sngOperKi) Then Exit Sub
    If SendKI(intKI2510, "sour:temp:lcon:der " & sngOperKd) Then Exit Sub
    If SendKI(intKI2510, "*sav 0") Then Exit Sub                'Save present instrument setup in memory location 0
    If SendKI(intKI2510, ":syst:pos sav0") Then Exit Sub       'Set power-up to setup stored in memory location 0
End If

End Sub
Public Sub lblD_Click()
'Display brief explanation of Derivative term

Call Deriv_Info

End Sub

Public Sub lblI_Click()
'Display brief explanation of Integral term

Call Integral_Info

End Sub

Public Sub lblP_Click()
'Display brief explanation of Proportional term

Call Gain_Info

End Sub

Private Sub Form_Load()

'Zero out Custom PID fields
txtCustomKp.Text = ""
txtCustomKi.Text = ""
txtCustomKd.Text = ""
optPID(3).value = False         'Ensure custom PID choice is not valid after clearing values

cmdOKPID.Enabled = False            'Initialize button to disabled, until a PID choice is made
cmdSaveSetup.Enabled = False        'Disable save setup button until a PID set is chosen

If intModel = int2510 Then          'If instrument is a 2510, then get present PID and hide Autotune PIDs
'    Call cmdGetPresentPID_Click     'Get PIDs stored in instrument
    Call GetPresentPID             'Get operational PIDs stored in instrument
    optPID(1).Visible = False       'Hide Min Settle time button
    txtMSETKp.Visible = False       'Hide Min settle coeff
    txtMSETKi.Visible = False       'Hide Min settle coeff
    txtMSETKd.Visible = False       'Hide Min settle coeff
    optPID(2).Visible = False       'Hide Min overshoot button
    txtMOVKp.Visible = False        'Hide Min overshoot coeff
    txtMOVKi.Visible = False        'Hide Min overshoot coeff
    txtMOVKd.Visible = False        'Hide Min overshoot coeff
        
    ElseIf intModel = int2510AT Then    '2510-AT, display all
'    Call cmdGet2510Data_Click       'Get all 3 sets of PIDs
    Call GetAllPIDData              'Get all 3 sets of PIDs
    optPID(1).Visible = True        'Display Min Settle time button
    txtMSETKp.Visible = True        'Display Min settle coeff
    txtMSETKi.Visible = True        'Display Min settle coeff
    txtMSETKd.Visible = True        'Display Min settle coeff
    optPID(2).Visible = True        'Display Min overshoot button
    txtMOVKp.Visible = True         'Display Min overshoot coeff
    txtMOVKi.Visible = True         'Display Min overshoot coeff
    txtMOVKd.Visible = True         'Display Min overshoot coeff
'    cmdGoToStartTemp.Enabled = False        'Disable start button until a PID set is chosen
    If Val(txtMSETKp.Text) = 0 Then 'If gain is zero, disable this PID choice
        optPID(1).Enabled = False
        Else
        optPID(1).Enabled = True
    End If
    If Val(txtMOVKp.Text) = 0 Then 'If gain is zero, disable this PID choice
        optPID(2).Enabled = False
        Else
        optPID(2).Enabled = True
    End If
End If

If Val(txtCustomKp.Text) = 0 Then 'If gain is zero, disable this PID choice
    optPID(3).value = False       'Ensure that Custom is not chosen
    optPID(3).Enabled = False
    Else
    optPID(3).Enabled = True
End If

'Set tool tip text
fraPID.ToolTipText = "Proportional, Integral and Derivative Gain Terms"
lblP.ToolTipText = "Proportional gain term, click for more info."
lblI.ToolTipText = "Integral gain term, click for more info."
lblD.ToolTipText = "Derivative gain term, click for more info."
cmdOKPID.ToolTipText = "Send Chosen PIDs to 2510 and close this window. Use ""Save PIDs"" for permanent storage in instrument."
cmdSaveSetup.ToolTipText = "Saves chosen PIDs into instrument, available after power-cycle."
cmdCancelPID.ToolTipText = "Exit window without changing active PID values."

End Sub

Private Sub optPID_Click(Index As Integer)
'Choose between: Present PID (coeff already programmed in 2510 for temp control),
'Min Settle Time and Min Overshoot parameters (only have
'choice with 2510-AT)

frmPIDCoeff.cmdOKPID.Enabled = True               'Enable Send PID button
frmPIDCoeff.cmdSaveSetup.Enabled = True             'Enable button

Select Case Index

       
Case 1          'Minimum Settle Time PIDs chosen

    'Copy PID values from MSET to present PID
    sngOperKp = CSng(txtMSETKp.Text)
    sngOperKi = CSng(txtMSETKi.Text)
    sngOperKd = CSng(txtMSETKd.Text)

Case 2          'Minimum Overshoot PIDs chosen

    'Copy PID values from MOV to present PID
    sngOperKp = CSng(txtMOVKp.Text)
    sngOperKi = CSng(txtMOVKi.Text)
    sngOperKd = CSng(txtMOVKd.Text)

Case 3          'Custom/manual PIDs chosen

    sngOperKp = CSng(txtCustomKp.Text)
    sngOperKi = CSng(txtCustomKi.Text)
    sngOperKd = CSng(txtCustomKd.Text)

End Select

End Sub

Private Sub txtCustomKd_Validate(Cancel As Boolean)
'Ensure value is within limits (one limit for older 2510 FW,
'second limit for newer (A07 and newer) 2510 FW and 2510-AT

Dim temp As Single

If (intModel = int2510) And (sngFWRev < 7) Then                 'Pick max for 2510
    temp = CheckInput(txtCustomKd.Text, minPID, max2510ID)       'Ensure value is within limits
    ElseIf (intModel = int2510AT) Or (sngFWRev > 6) Then        'Pick max for 2510-AT or newer firmware (7.0 or later)
    temp = CheckInput(txtCustomKd.Text, minPID, max2510ATPID)       'Ensure value is within limits
End If

txtCustomKd.Text = temp
sngOperKd = temp

Call CheckCustomPID         'If all Custom fields are not blank (and P <> 0) then enable Custom choice

End Sub

Private Sub txtCustomKi_Validate(Cancel As Boolean)
'Ensure value is within limits
Dim temp As Single

If (intModel = int2510) And (sngFWRev < 7) Then                  'Pick max for 2510
    temp = CheckInput(txtCustomKi.Text, minPID, max2510ID)       'Ensure value is within limits
    ElseIf (intModel = int2510AT) Or (sngFWRev > 6) Then    'Pick max for 2510-AT
    temp = CheckInput(txtCustomKi.Text, minPID, max2510ATPID)       'Ensure value is within limits
End If

txtCustomKi.Text = temp
sngOperKi = temp

Call CheckCustomPID         'If all Custom fields are not blank (and P <> 0) then enable Custom choice

End Sub

Private Sub txtCustomKp_Validate(Cancel As Boolean)
'Ensure value is within limits
'Note:  max PID value depends on model (and firmware??), see declared constants
Dim temp As Single

If (intModel = int2510) And (sngFWRev < 7) Then               'Pick max for 2510
    temp = CheckInput(txtCustomKp.Text, minPID, max2510P)       'Ensure value is within limits
    ElseIf (intModel = int2510AT) Or (sngFWRev > 6) Then    'Pick max for 2510-AT
    temp = CheckInput(txtCustomKp.Text, minPID, max2510ATPID)       'Ensure value is within limits
End If

txtCustomKp.Text = temp
sngOperKp = temp

Call CheckCustomPID         'If all Custom fields are not blank (and P <> 0) then enable Custom choice

End Sub

Public Sub CheckCustomPID()
'Check one of the PID coeff and ensure value is within limits
'If all three custom PID values are not blank, then save them to the
'operational variables

''Note:  max PID value depends on model (and firmware??), see declared constants
'
'If intModel = int2510 Then              'Pick correct max limit depending on model and coeff
''??? add check for 2510 max P
'    coeff = CheckInput(coeff, minPID, max2510P)
'    ElseIf intModel = int2510AT Then
'    coeff = CheckInput(coeff, minPID, max2510ATPID)
'End If

'If optPID(3).value = True Then
    If txtCustomKp.Text <> "" And txtCustomKi.Text <> "" And txtCustomKd.Text <> "" Then
'    If Val(txtCustomKp.Text) <> 0 And Val(txtCustomKi.Text) = 0 And Val(txtCustomKd.Text) = 0 Then
        If Val(txtCustomKp.Text) <> 0 Then
            optPID(3).Enabled = True            'Enable Custom choice
'            optPID_Click (3)                    'Transfer values to operational vars
        Else                                    'CustomKp = 0, not valid
        optPID(3).Enabled = False               'Disable Custom choice, because 0 isn't a valid gain
            If optPID(3).value = True Then               'Is Custom chosen?
                optPID(3).value = False                 '"turn off" custom, if it was chosen before P changed to zero
                cmdGoToStartTemp.Enabled = False        'Disable start, because no PID choice is made
                cmdSaveSetup.Enabled = False            'Disable save setup, because no PID choice is made
                cmdSendPID.Enabled = False              'Disable Send PID button
            End If
        End If
    End If
'End If

End Sub

